/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.HighlightJButton;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class ButtonFactory {
    private static boolean useHighlightButtons = false;
    private static boolean useButtonIcons = false;

    public static void useButtonIcons() {
        ButtonFactory.useButtonIcons(true);
    }

    public static void useButtonIcons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useButtonIcons = useit;
        }
    }

    public static void useHighlightButtons() {
        ButtonFactory.useHighlightButtons(true);
    }

    public static void useHighlightButtons(boolean useit) {
        if (System.getProperty("mrj.version") == null) {
            useHighlightButtons = useit;
        }
        ButtonFactory.useButtonIcons(useit);
    }

    public static JButton createButton(Icon icon, Color color) {
        if (useHighlightButtons) {
            if (useButtonIcons) {
                return new HighlightJButton(icon, color);
            }
            return new HighlightJButton("", color);
        }
        if (useButtonIcons) {
            return new JButton(icon);
        }
        return new JButton();
    }

    public static JButton createButton(String text, Color color) {
        JButton btn = null;
        btn = useHighlightButtons ? new HighlightJButton(text, color) : new JButton(text);
        if (text != null && text.length() > 0) {
            btn.setMnemonic(text.toLowerCase().charAt(0));
        }
        return btn;
    }

    public static JButton createButton(String text, Icon icon, Color color) {
        JButton btn = null;
        btn = useHighlightButtons ? (useButtonIcons ? new HighlightJButton(text, icon, color) : new HighlightJButton(text, color)) : (useButtonIcons ? new JButton(text, icon) : new JButton(text));
        if (text != null && text.length() > 0) {
            btn.setMnemonic(text.toLowerCase().charAt(0));
        }
        return btn;
    }

    public static JButton createButton(Action a, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(a, color);
        }
        return new JButton(a);
    }
}

