/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.IXMLWriter;
import com.izforge.izpack.adaptator.XMLException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class XMLWriter
implements IXMLWriter {
    private OutputStream outputStream;
    private String systemId;

    public XMLWriter() {
    }

    public XMLWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(IXMLElement element) {
        try {
            DOMSource source = new DOMSource(element.getElement().getOwnerDocument());
            TransformerFactory fabrique = TransformerFactory.newInstance();
            Transformer transformer = fabrique.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StreamResult result = this.outputStream != null ? new StreamResult(this.outputStream) : new StreamResult(this.systemId);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new XMLException(e);
        }
    }

    @Override
    public void setOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void setOutput(String systemId) {
        this.systemId = systemId;
    }
}

