/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.ResourceManager;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class LocaleDatabase
extends TreeMap {
    private static Map<String, LocaleDatabase> cachedLocales = new HashMap<String, LocaleDatabase>();
    public static final String LOCALE_DATABASE_DIRECTORY = "/langpacks/";
    public static final String LOCALE_DATABASE_DEF_SUFFIX = ".xml";
    private static final char TEMP_QUOTING_CHARACTER = '\uffff';
    static final long serialVersionUID = 4941525634108401848L;

    public static synchronized LocaleDatabase getLocaleDatabase(String isoCode) throws Exception {
        return LocaleDatabase.getLocaleDatabase(isoCode, false);
    }

    public static synchronized LocaleDatabase getLocaleDatabase(String isoCode, boolean reload) throws Exception {
        LocaleDatabase langpack = cachedLocales.get(isoCode);
        if (reload || langpack == null) {
            StringBuffer localeDefPath = new StringBuffer();
            localeDefPath.append(LOCALE_DATABASE_DIRECTORY);
            localeDefPath.append(isoCode);
            localeDefPath.append(LOCALE_DATABASE_DEF_SUFFIX);
            String path = localeDefPath.toString();
            if (LocaleDatabase.class.getResource(path) != null) {
                langpack = new LocaleDatabase(LocaleDatabase.class.getResourceAsStream(path));
                cachedLocales.put(isoCode, langpack);
            }
        }
        return langpack;
    }

    public static synchronized LocaleDatabase getLocaleDatabase() throws Exception {
        ResourceManager resourceManager = ResourceManager.getInstance();
        String defaultLocale = resourceManager.getLocale();
        return LocaleDatabase.getLocaleDatabase(defaultLocale);
    }

    public LocaleDatabase(InputStream in) throws Exception {
        this.add(in);
    }

    public void add(InputStream in) throws Exception {
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(in);
        if (!"langpack".equalsIgnoreCase(data.getName())) {
            throw new Exception("this is not an IzPack XML langpack file");
        }
        Vector<IXMLElement> children = data.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            IXMLElement e = children.get(i);
            String text = e.getContent();
            if (e.getAttribute("id").equals("osrequirementfailed")) {
                System.out.println();
            }
            if (text != null && !"".equals(text)) {
                this.put(e.getAttribute("id"), text.trim());
                continue;
            }
            this.put(e.getAttribute("id"), e.getAttribute("txt"));
        }
    }

    public String getString(String key) {
        String val = (String)this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }

    public String getString(String key, String[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] == null) {
                variables[i] = "N/A";
                continue;
            }
            if (!variables[i].startsWith("$")) continue;
            String curArg = variables[i];
            curArg = curArg.startsWith("${") ? curArg.substring(2, curArg.length() - 1) : curArg.substring(1);
            variables[i] = this.getString(curArg);
        }
        String message = this.getString(key);
        message = message.replace('\'', '\uffff');
        message = MessageFormat.format(message, variables);
        return message.replace('\uffff', '\'');
    }
}

