
var express = require('express'),
  app = express(),
  port = process.env.PORT || 3000,
//  mongoose = require('mongoose'),
//  Task = require('./api/models/releaseModel'), //created model loading here
  bodyParser = require('body-parser');
  var controllers = require('./api/controllers/releaseController');
// mongoose instance connection url connection
//mongoose.Promise = global.Promise;
//mongoose.connect('mongodb://localhost/Releasedb'); 

app.use(express.static('/'));
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());


var routes = require('./api/routes/releaseRoute'); //importing route
routes(app); //register the route


const server = app.listen(port);
setInterval(() => server.getConnections(
  (err, connections) => console.log(`${connections} connections currently open`)
), 1000);

process.on('SIGTERM', shutDown);
process.on('SIGINT', shutDown);

let connections = [];

server.on('connection', connection => {
  connections.push(connection);
  connection.on('close', () => connections = connections.filter(curr => curr !== connection));
});

function shutDown() {
  console.log('Received kill signal, shutting down gracefully');
  server.close(() => {
      console.log('Closed out remaining connections');
      process.exit(0);
  });

  setTimeout(() => {
      console.error('Could not close connections in time, forcefully shutting down');
      process.exit(1);
  }, 10000);

  connections.forEach(curr => curr.end());
  setTimeout(() => connections.forEach(curr => curr.destroy()), 5000);
}

nw.Window.open('index.html', {}, function(win) {win.maximize()});

console.log('release list RESTful API server started on: ' + port);
controllers.loadFiles('./json')
